% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{createColony}
\alias{createColony}
\title{Create a new Colony}
\usage{
createColony(x = NULL, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, one queen or virgin queen(s)}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
new \code{\link[SIMplyBee]{Colony-class}}
}
\description{
Level 2 function that creates a new \code{\link[SIMplyBee]{Colony-class}}
  to initiate simulations.
}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 15)

# Create an empty Colony class
colony <- createColony()

# Create Colony class with one or multiple virgin queens
colony1 <- createColony(x = basePop[2])
colony1
colony2 <- createColony(x = basePop[3:4])
colony2

# Create a mated Colony
colony1 <- cross(colony1, drones = drones)
colony1
}
