% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getPheno}
\alias{getPheno}
\alias{getQueenPheno}
\alias{getFathersPheno}
\alias{getVirginQueensPheno}
\alias{getWorkersPheno}
\alias{getDronesPheno}
\title{Access phenotype values of individuals in a caste}
\usage{
getPheno(x, caste = NULL, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getQueenPheno(x, collapse = FALSE, simParamBee = NULL)

getFathersPheno(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getVirginQueensPheno(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getWorkersPheno(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getDronesPheno(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link[AlphaSimR]{Pop-class}},
and character when \code{x} is a \code{\link[SIMplyBee]{Colony-class}} or
 \code{\link[SIMplyBee]{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{collapse}{logical, if the return value should be a single matrix
with phenotypes of all the individuals}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
vector of genetic values when \code{x} is \code{\link[SIMplyBee]{Colony-class}}
  and list of vectors of genetic values when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns phenotype values of individuals in a
  caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenPheno()}: Access phenotype value of the queen

\item \code{getFathersPheno()}: Access phenotype values of fathers

\item \code{getVirginQueensPheno()}: Access phenotype values of virgin queens

\item \code{getWorkersPheno()}: Access phenotype values of workers

\item \code{getDronesPheno()}: Access phenotype values of drones

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(nQtlPerChr = 10, var = 1)
SP$setVarE(varE = 1)

basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

# Input is a population
getPheno(x = getQueen(colony))
queens <- getQueen(apiary, collapse = TRUE)
getPheno(queens)

# Input is a colony
getPheno(colony, caste = "queen")
getQueenPheno(colony)

getPheno(colony, caste = "fathers")
getPheno(colony, caste = "fathers", nInd = 2)
getPheno(colony, caste = "fathers", nInd = 2) # random sample!
getFathersPheno(colony)
getFathersPheno(colony, nInd = 2)

getPheno(colony, caste = "workers")
getWorkersPheno(colony)
# Same aliases exist for all the castes!!!

# Get phenotypes for all individuals
getPheno(colony, caste = "all")
# Get all phenotypes in a single matrix
getPheno(colony, caste = "all", collapse = TRUE)

# Input is a MultiColony - same behaviour as for the Colony!
getPheno(apiary, caste = "queen")
getQueenPheno(apiary)

# Get the phenotypes of all individuals either by colony or in a single matrix
getPheno(apiary, caste = "all")
getPheno(apiary, caste = "all", collapse = TRUE)
}
\seealso{
\code{\link[AlphaSimR]{pheno}} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
