% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L3_Colonies.R
\name{selectColonies}
\alias{selectColonies}
\title{Select colonies from MultiColony object}
\usage{
selectColonies(
  multicolony,
  ID = NULL,
  n = NULL,
  p = NULL,
  by = NULL,
  selectTop = TRUE,
  simParamBee = NULL
)
}
\arguments{
\item{multicolony}{\code{\link[SIMplyBee]{MultiColony-class}}}

\item{ID}{character or numeric, ID of a colony (one or more) to be
selected}

\item{n}{numeric, number of colonies to select}

\item{p}{numeric, percentage of colonies selected (takes precedence
over \code{n})}

\item{by}{matrix, matrix of values to select by with names being
colony IDs (can be obtained with \code{\link[SIMplyBee]{calcColonyValue}}.
If NULL, the colonies are selected at random.
This parameter is used in combination
with \code{n} or \code{p} to determine the number of selected colonies, and
\code{selectTop} to determine whether to select the best or the worst colonies.}

\item{selectTop}{logical, selects highest (lowest) values if \code{TRUE} (\code{FALSE})}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
\code{\link[SIMplyBee]{MultiColony-class}} with selected colonies
}
\description{
Level 3 function that selects colonies from
  MultiColony object based on colony ID or random selection.
  Whilst user can provide all three arguments ID, p and n, there is a priority
  list: ID takes first priority. If no ID is provided, p takes precedence over n.
}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
mean <- c(10, 10 / SP$nWorkers)
varA <- c(1, 1 / SP$nWorkers)
corA <- matrix(data = c(
  1.0, -0.5,
  -0.5, 1.0
), nrow = 2, byrow = TRUE)
varE <- c(3, 3 / SP$nWorkers)
varA / (varA + varE)
SP$addTraitADE(nQtlPerChr = 100,
               mean = mean,
               var = varA, corA = corA,
               meanDD = 0.1, varDD = 0.2, corD = corA,
               relAA = 0.1, corAA = corA)
SP$setVarE(varE = varE)

basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1:4], nInd = 100)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)
apiary <- createMultiColony(basePop[2:5], n = 4)
apiary <- cross(apiary, drones = droneGroups[1:4])
apiary <- buildUp(apiary)
getId(apiary)

getId(selectColonies(apiary, ID = 1))
getId(selectColonies(apiary, ID = c("3", "4")))
# ... alternative
getId(apiary[1])
getId(apiary[["4"]])

# Select a random number of colonies
selectColonies(apiary, n = 3)
# Select a percentage of colonies
selectColonies(apiary, p = 0.2)

# Since selection is random, you would get a different set of colonies with
# each function call
getId(selectColonies(apiary, p = 0.5))
getId(selectColonies(apiary, p = 0.5))

# How to select colonies based on colony values?
# Obtain colony phenotype
colonyPheno <- calcColonyPheno(apiary)
# Select the best colony
selectColonies(apiary, n = 1, by = colonyPheno)

# Select the worst 2 colonies
selectColonies(apiary, n = 2, by = colonyPheno, selectTop = FALSE)

# Select best colony based on queen's genetic value for trait 1
queenGv <- calcColonyGv(apiary, FUN = mapCasteToColonyGv, workersTrait = NULL)
selectColonies(apiary, n = 1, by = queenGv)

}
