% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dopt.R
\name{Dopt}
\alias{Dopt}
\title{Calculate the D-optimal design under the SLSE}
\usage{
Dopt(N, u, tt, FUN, theta, num_iter = 1000)
}
\arguments{
\item{N}{The number of sample points in the design space.}

\item{u}{The discretized design space.}

\item{tt}{The level of skewness. When tt=0, it is equivalent to compute the D-optimal design under the ordinary least squares estimator.}

\item{FUN}{The function to calculate the derivative of the given model.}

\item{theta}{The parameter value of the model.}

\item{num_iter}{Maximum number of iteration.}
}
\value{
A list that contains 1. Value of the objective function at solution. 2. Status. 3. Optimal design
}
\description{
Calculate the D-optimal design under the SLSE
}
\details{
This function calculates the D-optimal design and the loss function under the D-optimality. The loss function under D-optimality is defined as the log determinant of the inverse of the Fisher information matrix.
}
\examples{
poly3 <- function(xi, theta){
  matrix(c(1, xi, xi^2, xi^3), ncol = 1)
}
Npt <- 101
my_design <- Dopt(N = Npt, u = seq(-1, +1, length.out = Npt),
   tt = 0, FUN = poly3, theta = rep(0,4), num_iter = 2000)
round(my_design$design, 3)
my_design$val

}
