#' A function that returns unadjusted p-values
#'
#' A function that returns unadjusted p-values.
#' @param res_SMAHP Outputs from SMAHP
#' @return A matrix of unadjusted p-values.
#' @export
#' @examples
#' \donttest{
#' data(example_dat)
#' surv_dat <- example_dat$surv_dat
#' res_SMAHP <- SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time,
#' status = surv_dat$status)
#' get_raw_p(res_SMAHP)
#' }

get_raw_p <- function(res_SMAHP){
  return(res_SMAHP$p_final_matrix)
}

#' A function that returns adjusted p-values
#'
#' A function that returns adjusted p-values.
#' @param res_SMAHP Outputs from SMAHP
#' @return A matrix of adjusted p-values.
#' @export
#' @examples
#' \donttest{
#' data(example_dat)
#' surv_dat <- example_dat$surv_dat
#' res_SMAHP <- SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time,
#' status = surv_dat$status)
#' get_adjusted_p(res_SMAHP)
#' }

get_adjusted_p <- function(res_SMAHP){
  return(res_SMAHP$p_adjusted_matrix)
}

#' A function that returns mediation-exposure matrix
#'
#' A function that returns final mediation-exposure matrix.
#' @param res_SMAHP Outputs from SMAHP
#' @return Mediation-exposure matrix.
#' @export
#' @examples
#' \donttest{
#' data(example_dat)
#' surv_dat <- example_dat$surv_dat
#' res_SMAHP <- SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time,
#' status = surv_dat$status)
#' get_pairs(res_SMAHP)
#' }

get_pairs <- function(res_SMAHP){
  return(res_SMAHP$p_med_matrix)
}



