% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rvlb_sm}
\alias{rvlb_sm}
\title{Sample from the vector Langevin-Bingham on the Stiefel manifold.}
\usage{
rvlb_sm(num, mA, vc, vx)
}
\arguments{
\item{num}{number of observations or sample size.}

\item{mA}{the matrix A which is symmetric ip*ip matrix.}

\item{vc}{the vector c with dimension ip.}

\item{vx}{the vector x, the initial value.}
}
\value{
an array containing a sample of draws from the vector Langevin-Bingham on the Stiefel manifold.
}
\description{
This function draws a sample from the vector Langevin-Bingham on the Stiefel manifold.
}
\details{
The vector Langevin-Bingham distribution on the Stiefel manifold has the density kernel:
\deqn{f(X) \propto \mathrm{etr}\{ x' A x + c' x \}}
where \eqn{x} satisfies \eqn{x'x = 1}, and \eqn{A} is a symmetric matrix.
}
\section{References}{

Hoff, P. D. (2009) "Simulation of the Matrix Bingham—von Mises—Fisher Distribution, With Applications to Multivariate and Relational Data", Journal of Computational and Graphical Statistics, Vol. 18, pp. 438-456.
}

\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{utils}
