% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e.R
\name{summaryEllipse}
\alias{summaryEllipse}
\title{SPOUSE (Scatter Plots Over-Viewed Using Summary Ellipses)}
\usage{
summaryEllipse(
  data1,
  data2,
  InEllipse = TRUE,
  OutEllipse = TRUE,
  InRect = TRUE,
  OutRect = TRUE,
  xlab = "X",
  ylab = "Y",
  main = "Summary Ellipse",
  coverage = 0.98,
  add = FALSE,
  wspace = 0.2,
  REGyonx = TRUE,
  REGxony = TRUE,
  ylim = c(min(data2) - wspace * (max(data2) - min(data2)), max(data2) + wspace *
    (max(data2) - min(data2))),
  xlim = c(min(data1) - wspace * (max(data1) - min(data1)), max(data1) + wspace *
    (max(data1) - min(data1))),
  pch = 1,
  cex = 0.7,
  col = "black"
)
}
\arguments{
\item{data1}{explanatory variable; numeric vector x}

\item{data2}{response variable; numeric vector y}

\item{InEllipse}{LOGICAL; True (Default) for showing the inner ellipse}

\item{OutEllipse}{LOGICAL; TRUE (Default) for showing the outer ellipse}

\item{InRect}{LOGICAL; TRUE (Default) for showing the inner rectangle}

\item{OutRect}{LOGICAL; TRUE (Default) for showing the outer rectangle}

\item{xlab}{x-variable label}

\item{ylab}{y-variable label}

\item{main}{Main title of the plot.}

\item{coverage}{the percentage of data that falls inside the outer ellipse}

\item{add}{adds a summary ellipse of a new data set to an existing plot. Compares multiple
groups.}

\item{wspace}{the amount of white space around the plot window; negative to suppress details around the boundaries (zoom in);
positive to zoom out. Default is 0.2.}

\item{REGyonx}{LOGICAL; TRUE (Default) for showing the regression line of y on x.}

\item{REGxony}{LOGICAL; TRUE (Default) for showing the regression line of x on y.}

\item{ylim}{bounds for the y-axis}

\item{xlim}{bounds for the x-axis}

\item{pch}{display symbols for the points in the scatter plot; Use different pch for different groups.}

\item{cex}{size of the points}

\item{col}{color of the points}
}
\value{
A new plot which shows the ellipses superimposed on top of each other.
}
\description{
Summary ellipses superimposed on a scatter plot contain all bi-variate summary
             statistics for regression analysis. Furthermore, the outer ellipse flags potential
             outliers. Multiple groups can be compared in terms of centers and spreads as illustrated
             in the examples.
}
\examples{
   x1<-iris3[,"Sepal L.","Setosa"]
   y1<-iris3[,"Sepal W.","Setosa"]
   x2<-iris3[,"Sepal L.","Versicolor"]
   y2<-iris3[,"Sepal W.","Versicolor"]
   x3<-iris3[,"Sepal L.","Virginica"]
   y3<-iris3[,"Sepal W.","Virginica"]
   xlim=c(4,8)
   ylim=c(1.5,5)
   summaryEllipse(x1,y1,xlim=xlim,ylim=ylim,InEllipse='F',InRect='F',
   OutRect='F',REGxony='F',REGyonx='F')
   summaryEllipse(x2,y2,add=TRUE,pch=20,col="brown",InEllipse='F',InRect='F',
   OutRect='F',REGxony='F',REGyonx='F')
   summaryEllipse(x3,y3,add=TRUE,pch=19,col="grey",InEllipse='F',InRect='F',
   OutRect='F',REGxony='F',REGyonx='F')
   #end of example
}
