% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{optimize_simple}
\alias{optimize_simple}
\title{Simple Parameter Optimization Without GALAHAD}
\usage{
optimize_simple(data, constraints = "positive")
}
\arguments{
\item{data}{Data frame with time and response columns}

\item{constraints}{Character vector specifying constraints ("positive", "none")}
}
\value{
Named vector of parameters: rate, offset, scale
}
\description{
A simplified version of parameter optimization that doesn't require GALAHAD.
Used for examples and testing when GALAHAD is not available.
}
\examples{
# Create simple growth data
simple_data <- data.frame(
  time = rep(0:7, 4),
  response = rnorm(32, mean = rep(seq(0, 50, length.out = 8), 4), sd = 2)
)

# Optimize parameters
params <- optimize_simple(simple_data, constraints = "positive")
print(params)

}
