% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_expand_by_group.R
\name{expand_by_group}
\alias{expand_by_group}
\title{Create a data frame from all combinations between two specified variables within each group}
\usage{
expand_by_group(.data, grp, var1, var2)
}
\arguments{
\item{.data}{A data frame.}

\item{grp}{A column name indicating the group.}

\item{var1}{A column name indicating the control.}

\item{var2}{A column name indicating the treatment.}
}
\value{
Returns a data frame containing all combinations of the specified variables for each group.
The structure of the returned data frame includes:
\itemize{
\item All combinations of \code{var1} and \code{var2} within each group.
\item The group column (\code{grp}).
\item Rows with NA values removed.
}
}
\description{
\code{expand_by_group()} generates all combinations (Cartesian product) of two specified variables within each group in your dataframe.
}
\examples{
grp <- "Series"
var1 <- "control_sample"
var2 <- "treated_sample"

ebg <- expand_by_group(MetadataABA,
                       grp,
                       var1,
                       var2)

unique_series <- unique(MetadataABA$Series)

lapply(unique_series,
       function(x) subset(ebg, Series == x))


}
