% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ioptimum.R
\name{ioptimum}
\alias{ioptimum}
\title{Identification of the Optimal Sampling Effort}
\usage{
ioptimum(xx, multi.site = TRUE, c1 = 10, c2 = 5, c3 = 2.5)
}
\arguments{
\item{xx}{A data frame generated by \code{\link{summary_ssp}}.}

\item{multi.site}{Logical. Indicates whether multiple sites were simulated.}

\item{c1}{First cut threshold. Default is 10\% improvement over the highest MultSE.}

\item{c2}{Second cut threshold. Default is 5\% improvement over the highest MultSE.}

\item{c3}{Third cut threshold. Default is 2.5\% improvement over the highest MultSE.}
}
\value{
A vector or matrix indicating the sampling sizes corresponding to each cut-off point.
}
\description{
Estimates the sampling effort at which the improvement in precision (MultSE) per additional sampling unit
becomes sub-optimal or redundant, based on predefined cut-off thresholds.
}
\details{
Sampling efforts between the minimum (e.g. 2 samples) and \code{c1} represent the necessary effort to achieve acceptable precision.
Efforts between \code{c1} and \code{c2} reflect sub-optimal gains, and those between \code{c2} and \code{c3} are considered optimal.
Beyond \code{c3}, any additional effort results in marginal improvements in MultSE and may be considered redundant.
This classification helps support cost-benefit decisions in ecological survey design (see Underwood, 1990).
If \code{c3} is not reached within the simulated range, the maximum available effort is returned with a warning.
}
\note{
The cut-off thresholds are arbitrary and should be adjusted based on the ecological question and resource availability.
In some cases, \code{c3} may not be reached within the range of simulated sampling efforts.
}
\examples{
## Single site example
data(micromollusk)
par.mic <- assempar(data = micromollusk, type = "P/A", Sest.method = "average")
sim.mic <- simdata(par.mic, cases = 2, N = 20, sites = 1)
sam.mic <- sampsd(dat.sim = sim.mic,
                  Par = par.mic,
                  transformation = "P/A",
                  method = "jaccard",
                  n = 10,
                  m = 1,
                  k = 3)
summ.mic <- summary_ssp(results = sam.mic, multi.site = FALSE)
opt.mic <- ioptimum(xx = summ.mic, multi.site = FALSE)

## See the full multi-site workflow in the vignette

}
\references{
Underwood, A. J. (1990). Experiments in ecology and management: Their logics, functions and interpretations. Australian Journal of Ecology, 15, 365–389.

Guerra-Castro, E.J., Cajas, J.C., Simões, N., Cruz-Motta, J.J., & Mascaró, M. (2021). SSP: an R package to estimate sampling effort in studies of ecological communities. Ecography 44(4), 561-573. doi: \doi{10.1111/ecog.05284}
}
\seealso{
\code{\link{plot_ssp}}, \code{\link{summary_ssp}}, \code{\link{sampsd}}
}
