% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error.R
\name{sc_last_error}
\alias{sc_last_error}
\alias{sc_last_error_parsed}
\title{Error handling for the STATcube REST API}
\usage{
sc_last_error()

sc_last_error_parsed()
}
\value{
The return value from \code{httr::GET()} or \code{httr::POST()}.
}
\description{
In case API requests are unsuccessful, \code{STATcubeR} will throw errors
to summarize the httr error type and its meaning.
Requests are considered unsuccessful if one of the following applies
\itemize{
\item The response returns \code{TRUE} for \code{httr::http_error()}.
\item The response is not of type \code{"application/json"}
}

In some cases it is useful to get direct access to a faulty response object.
For that purpose, it is possible to use \code{\link[=sc_last_error]{sc_last_error()}} which will provide
the httr response object for the last unsuccessful request.
}
\section{Functions}{
\itemize{
\item \code{sc_last_error_parsed()}: returns the last error as a list containing
the response content and the response status

}}
\examples{
\dontshow{if (sc_key_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
try(sc_table_saved("invalid_id"))
last_error <- sc_last_error()
httr::content(last_error)
str(sc_last_error_parsed())
\dontshow{\}) # examplesIf}
}
