% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R, R/schema_db.R
\name{sc_schema}
\alias{sc_schema}
\alias{print.sc_schema}
\alias{sc_schema_flatten}
\alias{sc_schema_catalogue}
\alias{sc_schema_db}
\title{Create a request against the /schema endpoint}
\usage{
sc_schema(id = NULL, depth = NULL, language = NULL, key = NULL, server = "ext")

\method{print}{sc_schema}(x, tree = NULL, ..., limit = 30)

sc_schema_flatten(x, type)

sc_schema_catalogue(depth = "folder", ...)

sc_schema_db(id, depth = "valueset", language = c("en", "de"), key = NULL)
}
\arguments{
\item{id}{A resource identifier in uid format. In case of \code{sc_schema_db()},
this should be a database id. For \code{sc_schema()} any resource-id
(folder, measure, table, ...) is accepted.}

\item{depth}{If provided, the request will recurse into the given level.
For datasets, available options are \code{NULL} (no recursion), \code{"folder"},
\code{"field"} and \code{"valueset"}. For the catalogue, only \code{NULL} and \code{"folder"}
are applicable.}

\item{language}{The language to be used for labeling. \code{"en"} or \code{"de"}}

\item{key}{(\code{string}) An API key. To display your key, call
\code{\link[=sc_browse_preferences]{sc_browse_preferences()}}.}

\item{server}{A STATcube API server. Defaults to the external Server via
\code{"ext"}. Other options are \code{"red"} for the editing server and \code{"prod"} for
the production server. External users should always use the default option \code{"ext"}.}

\item{x}{an object of class \code{sc_schema()} i.e. the return value of
\code{\link[=sc_schema]{sc_schema()}}, \code{\link[=sc_schema_db]{sc_schema_db()}} or \code{\link[=sc_schema_catalogue]{sc_schema_catalogue()}}.}

\item{tree}{whether to use the \href{https://rdrr.io/cran/data.tree/man/data.tree.html}{\code{data.tree}} package for printing.}

\item{limit, ...}{passed to \code{\link[data.tree:print.Node]{data.tree::print.Node()}} if \code{tree} is set
to \code{TRUE}. Ignored otherwise.}

\item{type}{a schema type such as "DATABASE", "VALUE" or "TABLE".
See \href{https://docs.wingarc.com.au/superstar/9.12/open-data-api/open-data-api-reference/schema-endpoint#id-.SchemaOpenDataAPIv9.9.6-SchemaTypesandAssociatedIDSchemes}{the API reference} for a list of all schema types.}
}
\value{
\itemize{
\item for \code{\link[=sc_schema]{sc_schema()}} and \code{\link[=sc_schema_db]{sc_schema_db()}}: an object of class \code{sc_schema}
\item for \code{\link[=sc_schema_flatten]{sc_schema_flatten()}}: a \code{data.frame}
\item for \code{\link[=sc_schema_catalogue]{sc_schema_catalogue()}}: a \code{list}
}
}
\description{
Invoke the \href{https://docs.wingarc.com.au/superstar/9.12/open-data-api/open-data-api-reference/schema-endpoint}{\strong{/schema}} endpoint of the STATcube REST API.
This endpoint can be used to get all available databases and tables
as well as metadata about specific databases.

The main function \code{sc_schema()} can be used with any resource id.
\code{\link[=sc_schema_catalogue]{sc_schema_catalogue()}} and \code{\link[=sc_schema_db]{sc_schema_db()}} are very simple
wrapper functions around \code{\link[=sc_schema]{sc_schema()}} and are comparable to the
catalogue explorer or the
table view of the STATcube GUI.

The responses of the API are tree-like data structures which
are wrapped into a class called \code{sc_schema} to simplify the usage in R.
}
\section{Functions}{
\itemize{
\item \code{sc_schema_flatten()}: turns a \code{sc_schema} object into a \code{data.frame}

\item \code{sc_schema_catalogue()}: is similar to the
\href{https://portal.statistik.at/statistik.at/ext/statcube/jsf/dataCatalogueExplorer.xhtml}{catalogue explorer} of the STATcube GUI and returns
a tree-type object containing all databases and tables.

\item \code{sc_schema_db()}: is similar to the
\href{https://portal.statistik.at/statistik.at/ext/statcube/opendatabase?id=deake005}{table view}
of the STATcube GUI and gives information about all measures and
classification fields for a specific database

}}
\section{Printing with data.tree}{

\code{limit} and \code{...} will simply be ignored if \code{tree} is set to \code{FALSE}, which is
the default. The printing via \code{data.tree} can take longer than the default
implementation because \code{x} will need to be converted into a \code{data.tree} node.
To use \code{data.tree} printing permanently, use

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(STATcubeR.print_tree = TRUE)
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (sc_key_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
my_catalogue <- sc_schema_catalogue()

## print
my_catalogue

## access the parsed catalogue
my_catalogue$Statistics$`Labour Market`
my_catalogue$Statistics$`Labour Market`$`Working hours (Labour Force Survey)`

db_schema <- sc_schema_db("deake005")

# printing
db_schema

# access child nodes
db_schema$`Demographic Characteristics`
db_schema$`Demographic Characteristics`$Gender$Gender
db_schema$`Demographic Characteristics`$Gender$Gender$male

# access the raw response from httr::GET()
my_response <- attr(db_schema, "response")
my_response$headers$date
my_content <- httr::content(my_response)
my_content$label

# print with data.tree

 treeX_B1 <- sc_schema("str:group:deake005:X_B1", depth = "valueset")
 print(treeX_B1, tree = TRUE)
\dontshow{\}) # examplesIf}
}
\concept{functions for /schema}
