% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-example.R
\name{create_example}
\alias{create_example}
\title{Create Example}
\usage{
create_example(
  progression_table,
  reps = c(3, 5, 10),
  volume = c("intensive", "normal", "extensive"),
  type = c("grinding", "ballistic"),
  ...
)
}
\arguments{
\item{progression_table}{Progression table function}

\item{reps}{Numeric vector. Default is \code{c(3, 5, 10)}}

\item{volume}{Character vector. Default is \code{c("intensive", "normal", "extensive")}}

\item{type}{Character vector. Type of max rep table. Options are grinding (Default), ballistic,
and conservative}

\item{...}{Extra arguments forwarded to \code{progression_table}}
}
\value{
Data frame with the following structure
\describe{
\item{type}{Type of the set and rep scheme}
\item{reps}{Number of reps performed}
\item{volume}{Volume type of the set and rep scheme}
\item{Step 1}{First progression step \%1RM}
\item{Step 2}{Second progression step \%1RM}
\item{Step 3}{Third progression step \%1RM}
\item{Step 4}{Fourth progression step \%1RM}
\item{Step 2-1 Diff}{Difference in \%1RM between second and first progression step}
\item{Step 3-2 Diff}{Difference in \%1RM between third and second progression step}
\item{Step 4-3 Diff}{Difference in \%1RM between fourth and third progression step}
}
}
\description{
This function create simple example using \code{progression_table}
}
\examples{
create_example(progression_RIR)

# Create example using specific reps-max table and k value
create_example(
  progression_RIR,
  max_perc_1RM_func = max_perc_1RM_modified_epley,
  kmod = 0.0388
)
}
