% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_AdmUnNames.R
\name{Get_AdmUnNames}
\alias{Get_AdmUnNames}
\title{Download the names and codes of Italian LAU and NUTS-3 administrative units}
\source{
<https://situas.istat.it/web/#/territorio>
}
\usage{
Get_AdmUnNames(Date = Sys.Date(), autoAbort = FALSE)
}
\arguments{
\item{Date}{Character. The date at which administrative unit codes are sought for. Important: must be in the format: "yyyy-mm-dd".
Current date by default.}

\item{autoAbort}{Logical. Whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, including: NUTS-3 code, NUTS-3 abbreviation,
LAU code, LAU name (description) and cadastral code. All variables are characters except for the NUTS-3 code.
}
\description{
This function downloads a file provided by the Italian National Institute of Statistics including all the codes of administrative units in Italy. As of today, it is the easiest way to map directly cadastral codes to municipality codes.
}
\examples{
 \donttest{
  AdmUnNames25 <- Get_AdmUnNames("2025-01-01", autoAbort = TRUE)
  # Codes for a randomly chosen province, say, Brindisi (Apulia)
  AdmUnNames25[which(AdmUnNames25$Province_code==74),]
 }




}
