% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_computeDopplerFreq2Bins}
\alias{seasonder_computeDopplerFreq2Bins}
\title{Convert Doppler Frequencies to Doppler Bins}
\usage{
seasonder_computeDopplerFreq2Bins(
  seasonder_cs_object,
  doppler_values,
  doppler_freqs,
  delta_freq,
  nDoppler
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object.}

\item{doppler_values}{A numeric vector specifying the Doppler frequencies to be converted into bin indices.}

\item{doppler_freqs}{A numeric vector containing the Doppler frequencies corresponding to each bin.}

\item{delta_freq}{A numeric scalar specifying the frequency step size (difference between consecutive Doppler bins).}

\item{nDoppler}{An integer indicating the total number of Doppler bins.}
}
\value{
An integer vector of Doppler bin indices corresponding to the input Doppler frequencies. Values that fall outside the valid bin range are assigned \code{NA}.
}
\description{
This function converts a set of Doppler frequency values into their corresponding Doppler bin indices using predefined Doppler frequency bins and frequency step size.
}
\details{
The function constructs a set of bin boundaries using the Doppler frequencies. The leftmost boundary is adjusted by subtracting \code{delta_freq} from the first Doppler frequency to extend the range.

The function then applies \code{\link{findInterval}} to determine the corresponding bin index for each input Doppler frequency. The bin assignment process follows these rules:
\itemize{
\item \code{rightmost.closed = TRUE}: The last bin interval includes its upper boundary.
\item \code{all.inside = FALSE}: Values outside the defined frequency range are assigned indices below 1 or above \code{nDoppler}.
\item \code{left.open = TRUE}: The left interval is open, meaning values exactly equal to a boundary are assigned to the higher bin.
}

After determining the bin indices, values that are out of range (\code{bins < 1} or \code{bins > nDoppler}) are set to \code{NA}.
}
\seealso{
\code{\link{seasonder_Bins2NormalizedDopplerFreq}} for converting bins back to normalized Doppler frequencies.
\code{\link{findInterval}} for details on interval-based bin selection.
}
