% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_defaultFOR_parameters}
\alias{seasonder_defaultFOR_parameters}
\title{Default First-Order Radial Processing Parameters}
\usage{
seasonder_defaultFOR_parameters()
}
\value{
A named list containing the default parameter values.
}
\description{
This function returns a list of default parameters for first-order
radial processing in CODAR's Radial Suite R7. Each parameter has an equivalent
R8 version, where applicable, often expressed in decibels (dB).
}
\details{
\strong{Parameter Descriptions:}
\enumerate{
\item \strong{nsm (R8: Doppler Smoothing)}
\itemize{
\item \strong{Default value:} 2
\item \strong{Usage:} Sets how many Doppler bins (points) are smoothed. Smoothing helps
remove jagged edges in the sea echo spectrum, aiding in locating the null
between the first and second order (or noise floor).
\item \strong{Recommended values:} Typically 2 to 6. Default in Radial Suite R8 is 2
\item \strong{Effects of over-/under-smoothing:}
\itemize{
\item Too high: May smear out the real null, causing the first order to appear
wider.
\item Too low: Jagged minima may cause the null to be detected inside the
first-order region, making it appear too narrow.
}
}
\item \strong{fdown (R8: Null Below Peak Power)}
\itemize{
\item \strong{Default value (R7):} 10
\item \strong{Equivalent in dB (R8):} 10 dB
\item \strong{Usage:} Defines how far below the peak power the algorithm must descend
(in dB) before searching for the null that separates the first and second
order. This helps avoid including second-order energy as part of the
first-order.
\item \strong{Recommended range:} 3.981072 to 31.62278 (6 to 15 dB in R8). Default in Radial Suite R8 is 10 dB
\item \strong{Effects of misconfiguration:}
\itemize{
\item Too large: The null search may be bypassed entirely, causing
second-order content to be included in the first order.
\item Too small: The null may be found inside the first-order region,
excluding valid Bragg energy.
}
}
\item \strong{flim (R8: Peak Power Dropoff)}
\itemize{
\item \strong{Default value (R7):} 100
\item \strong{Equivalent in dB (R8):} 20 dB
\item \strong{Usage:} Once a peak is located, any spectral bins that are more than
\code{flim} below the peak (in linear scale) or \verb{20 dB} below the peak (in dB
scale) are excluded from the first-order region.
\item \strong{Recommended range:} 15.84893 to 316.2278 (12 to 25 dB in R8). Default in Radial Suite R8 is 20 dB.
\item \strong{Effects of misconfiguration:}
\itemize{
\item Too high: May include non-Bragg signal and yield spurious high
velocity estimates.
\item Too low: May cut out part of the actual Bragg signal, underestimating
maximum velocities.
}
}
\item \strong{noisefact (R8: Signal to Noise)}
\itemize{
\item \strong{Default value (R7):} 3.981072
\item \strong{Equivalent in dB (R8):} 6 dB
\item \strong{Usage:} Sets the threshold above the noise floor that must be exceeded
for the algorithm to accept Doppler bins as potential first-order.
\item \strong{Recommended range:} 3.981072 to 7.943282 (6 to 9 dB in R8). Default in Radial Suite R8 is 6 dB
\item \strong{Effects of misconfiguration:}
\itemize{
\item Too high: Useful Bragg data could be excluded.
\item Too low: Noise or spurious signals may be included as Bragg.
}
}
\item \strong{currmax (R8: Maximum Velocity)}
\itemize{
\item \strong{Default value:} 2 m/s
\item \strong{Usage:} Sets a maximum radial velocity,
preventing first-order limits from extending beyond realistic current
speeds for the site.
\item \strong{Effects of misconfiguration:}
\itemize{
\item Too high: May include non-Bragg data, producing overestimated
velocities.
\item Too low: May exclude valid Bragg data, underestimating velocities.
}
}
\item \strong{reject_distant_bragg (Reject Distant Bragg)}
\itemize{
\item \strong{Default value:} TRUE
\item \strong{Usage:} Rejects a first-order region if its limits are farther from
the Bragg index (central Doppler bin for zero current) than the width of
the region itself. Helps avoid misclassifying strong but isolated signals
(e.g., ships) as Bragg.
\item \strong{Recommendation:} Usually keep this enabled unless operating at a site
where only strongly biased positive or negative currents are expected.
}
\item \strong{reject_noise_ionospheric (Reject Noise/Ionospheric)}
\itemize{
\item \strong{Default value:} TRUE
\item \strong{Usage:} Rejects Bragg if the total non-Bragg power in a range cell
exceeds the Bragg power by at least the threshold set in
\code{reject_noise_ionospheric_threshold}. Recommended to set as FALSE for 42 MHz systems.
\item \strong{Recommendation:} Enable if the site experiences significant noise.
}
\item \strong{reject_noise_ionospheric_threshold (Reject Noise/Ionospheric Threshold)}
\itemize{
\item \strong{Default value:} 0
\item \strong{Equivalent in dB:} 0 dB
\item \strong{Usage:} Difference threshold (in dB) for comparing non-Bragg power to
Bragg power. If non-Bragg power is higher by this threshold, the Bragg is
rejected.
\item \strong{Recommended setting:} Typically 0 dB. Increase only if needed to be
less sensitive to noise contamination.
}
}
}
\examples{
params <- seasonder_defaultFOR_parameters()
print(params)

}
\references{
COS. SeaSonde Radial Suite Release 7; CODAR Ocean Sensors (COS): Mountain View, CA, USA, 2013.
COS. SeaSonde Radial Suite Release 8; CODAR Ocean Sensors (COS): Mountain View, CA, USA, 2016.
}
