% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getFOR_nsm}
\alias{seasonder_getFOR_nsm}
\title{Retrieve FOR Doppler Smoothing Factor (nsm)}
\usage{
seasonder_getFOR_nsm(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR parameters.}
}
\value{
The value of the 'nsm' parameter.
}
\description{
This function retrieves the Doppler smoothing factor ('nsm') from the FOR parameters
in a SeaSondeRCS object.
}
\examples{
# Minimal example for seasonder_getFOR_nsm
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
smoothing_factor <- seasonder_getFOR_nsm(cs_obj)
print(smoothing_factor)
}
