% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFOR_flim}
\alias{seasonder_setFOR_flim}
\title{Set FOR Null Limit (flim)}
\usage{
seasonder_setFOR_flim(seasonder_cs_object, flim)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object with FOR parameters.}

\item{flim}{A numeric value specifying the new null limit.}
}
\value{
The updated SeaSondeRCS object with the new \code{flim} value.
}
\description{
This function sets the null limit (\code{flim}) used for defining the first-order region in the SeaSondeRCS object.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setFOR_flim(cs_obj, 100)
}
