% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_SeaSondeRCSExportFORBoundaries}
\alias{seasonder_SeaSondeRCSExportFORBoundaries}
\title{Export First Order Region (FOR) Boundaries}
\usage{
seasonder_SeaSondeRCSExportFORBoundaries(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the computed FOR data.}
}
\value{
A data frame with the boundaries of the FOR for each range cell.
}
\description{
This function exports the boundaries of the First Order Region (FOR) for each range cell
from a \code{SeaSondeRCS} object, providing the first and last Doppler bins for both
negative and positive Bragg regions.
}
\details{
\strong{Purpose:}
This function retrieves the computed FOR data from the \code{SeaSondeRCS} object and extracts
the boundary Doppler bins for each range cell. The result is a data frame with the following columns:
\itemize{
\item \code{range_cell}: The index of the range cell.
\item \code{first_neg_doppler_cell}: The first Doppler bin in the negative Bragg region.
\item \code{last_neg_doppler_cell}: The last Doppler bin in the negative Bragg region.
\item \code{first_pos_doppler_cell}: The first Doppler bin in the positive Bragg region.
\item \code{last_pos_doppler_cell}: The last Doppler bin in the positive Bragg region.
}

\strong{Steps:}
\enumerate{
\item Retrieve the FOR data using \code{\link{seasonder_getSeaSondeRCS_FOR}}.
\item Iterate through each range cell and extract the Doppler bins for both negative and positive Bragg regions.
\item Determine the range (first and last bins) for each region.
\item Combine the results into a single data frame, omitting empty entries.
}

\strong{Use Case:}
This function is useful for exporting the computed FOR boundaries to a format that can
be further analyzed or visualized.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
boundaries <- seasonder_SeaSondeRCSExportFORBoundaries(cs_obj)
head(boundaries)
}
\seealso{
\itemize{
\item \code{\link{seasonder_getSeaSondeRCS_FOR}} for retrieving the FOR data.
}
}
