% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_exportLLUVRadialMetrics}
\alias{seasonder_exportLLUVRadialMetrics}
\title{Export LLUV Radial Metrics to a File}
\usage{
seasonder_exportLLUVRadialMetrics(seasonder_cs_object, LLUV_path, ...)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC detection data and related metadata.}

\item{LLUV_path}{A character string specifying the output file path for the LLUV radial metrics.}

\item{...}{Additional arguments passed to \code{seasonder_exportRadialMetrics}.}
}
\value{
Invisibly returns a data frame containing the radial metrics used in the export.
}
\description{
This function extracts radial metrics from a SeaSondeRCS object and formats them for export using
defined mustache templates. The formatted output, which includes MUSIC parameters, antenna pattern corrections,
noise thresholds, and other spectral metrics, is written to a specified file. Additionally, the function
returns the computed radial metrics as a data frame.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the radial metrics from the SeaSondeRCS object using \code{seasonder_exportRadialMetrics}.
\item Obtains MUSIC parameters and antenna pattern attributes from the object.
\item Formats numeric values using predefined formats for each column.
\item Renders a data template (from "LLUV_RDM1_data.mustache") with the formatted radial metrics.
\item Generates a deterministic UUID from the rendered data.
\item Renders an overall LLUV template (from "LLUV_RDM1.mustache") that incorporates the radial parameters,
formatted data, header information, and the generated UUID.
\item Writes the rendered LLUV content to the file specified by \code{LLUV_path}.
}
}
\examples{
# Prepare a SeaSondeRCS object with MUSIC data
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
FOR <- seasonder_getSeaSondeRCS_FOR(cs_obj)
cs_obj <- seasonder_setSeaSondeRCS_FOR(cs_obj,FOR[4:5])
# Optionally, run MUSIC in FOR context to populate MUSIC data
cs_obj <- seasonder_runMUSICInFOR(cs_obj)
radial_metrics <- seasonder_exportLLUVRadialMetrics(cs_obj, tempfile(fileext = ".ruv"))
head(radial_metrics)
}
