% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getBinsRadialVelocity}
\alias{seasonder_getBinsRadialVelocity}
\title{Calculate Radial Velocities for Each Doppler Bin}
\usage{
seasonder_getBinsRadialVelocity(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object created using \code{seasonder_createSeaSondeRCS}.
This object contains the necessary data for calculating the Doppler bins
frequencies and, subsequently, radial velocities.}
}
\value{
A numeric vector containing the radial velocities (in m/s) for each
Doppler bin, calculated for the high boundary of each Doppler bin interval.
The velocities provide insight into the scatterers' radial movement within the
radar's observation area.
}
\description{
Computes the radial velocities for each Doppler bin interval's high boundary
for a SeaSonde radar cross-section (CS) object, as typically visualized in
SpectraPlotterMap. This function utilizes the Doppler shift frequency alongside
the radar's wave number and Bragg frequency to transform frequency measurements
into radial velocities. The calculation is based on the relationship
between the Doppler shift frequency and the velocity of surface currents
within the radar's field of view.
}
\details{
Specifically, the radial velocity \eqn{v = (Freq - BraggFreq)/(2 * k_0)}
is used, where \eqn{v} is the radial velocity, \eqn{Freq} is the Doppler
shift frequency for the bin, \eqn{BraggFreq} is the Bragg frequency
(negative for frequencies below 0 and positive for frequencies equal or above 0),
and \eqn{k_0} is the radar wave number divided by 2\eqn{\pi}.
}
\seealso{
\code{\link{seasonder_getDopplerBinsFrequency}},
\code{\link{seasonder_getBraggDopplerAngularFrequency}},
\code{\link{seasonder_getRadarWaveNumber}}
}
