% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chirps.R
\name{upscale_chirps}
\alias{upscale_chirps}
\title{Upscales monthly CHIRPS data to a coarser grid}
\usage{
upscale_chirps(
  update = TRUE,
  years = NULL,
  months = NULL,
  upscale_grid = data.table(expand.grid(lon = seq(GHA_extent()[1], GHA_extent()[2], 0.5),
    lat = seq(GHA_extent()[3], GHA_extent()[4], 0.5))),
  root_dir = NULL,
  version = "UCSB",
  us_dir = file.path(root_dir, "upscaled")
)
}
\arguments{
\item{update}{Logical, if TRUE, files that have already been upscaled are skipped}

\item{years, months}{Which years and months do you want to upscale? NULL upscales everything there is (except if update is TRUE).}

\item{upscale_grid}{A regular lon/lat grid for upscaling. Defaults to half degrees.}

\item{root_dir}{directory where the high-resolution file is stored.}

\item{version}{Version specifier, should be 'UCSB' or 'ICPAC'. The latter only works if you have access to CHIRPS blended.}

\item{us_dir}{Directory where the low-resolution file will be stored.}
}
\value{
Nothing.
}
\description{
this is mostly auxiliary and called from download_chirps_monthly.
Uses the function upscale_regular_lon_lat, but derives the weights for upscaling only once for efficiency and avoids simultaneous loading of all CHIRPS data.
}
\examples{
if(interactive()){
upscale_chirps()
}

}
