% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_helpers.R
\name{compare_selectors_single}
\alias{compare_selectors_single}
\title{Run all selectors once on a dataset}
\usage{
compare_selectors_single(X, Y, include_enet = TRUE)
}
\arguments{
\item{X}{Numeric matrix (n × p) of mean-submodel predictors.}

\item{Y}{Numeric response in (0,1). Values are squeezed to (0,1) internally.}

\item{include_enet}{Logical; include ENet if \code{gamlss.lasso} is installed.}
}
\value{
A list with:
\describe{
\item{coefs}{Named coefficient vectors for each selector.}
\item{table}{Long data frame with columns \code{selector}, \code{variable}, \code{coef}, \code{selected}.}
}
}
\description{
Convenience wrapper that runs AIC/BIC/AICc stepwise, GAMLSS LASSO (and ENet
when available), and the pure glmnet IRLS selector, then collates coefficients
into a long table for comparison. Observations containing \code{NA} in either \code{X}
or \code{Y} are removed prior to fitting. Column names are temporarily shortened
to satisfy selector requirements and avoid clashes; the outputs remap them to
the original labels before returning so the reported variables always match
the input design.
}
\examples{
set.seed(1)
X <- matrix(rnorm(300), 100, 3); Y <- plogis(X[, 1])
Y <- rbeta(100, Y * 30, (1 - Y) * 30)
single <- compare_selectors_single(X, Y, include_enet = FALSE)
head(single$table)
}
