% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createSccsAnalysesSpecifications}
\alias{createSccsAnalysesSpecifications}
\title{Create full SCCS analysis specifications}
\usage{
createSccsAnalysesSpecifications(
  sccsAnalysisList,
  exposuresOutcomeList,
  analysesToExclude = NULL,
  combineDataFetchAcrossOutcomes = FALSE,
  sccsDiagnosticThresholds = SelfControlledCaseSeries::createSccsDiagnosticThresholds(),
  controlType = "outcome"
)
}
\arguments{
\item{sccsAnalysisList}{A list of objects of type \code{SccsAnalysis} as created using the \code{\link[=createSccsAnalysis]{createSccsAnalysis()}} function.}

\item{exposuresOutcomeList}{A list of objects of type \code{ExposuresOutcome} as created using the \code{\link[=createExposuresOutcome]{createExposuresOutcome()}} function.}

\item{analysesToExclude}{Analyses to exclude. See the Analyses to Exclude section for details.}

\item{combineDataFetchAcrossOutcomes}{Should fetching data from the database be done one outcome
at a time, or for all outcomes in one fetch? Combining
fetches will be more efficient if there is large overlap in
the subjects that have the different outcomes.}

\item{sccsDiagnosticThresholds}{An object of type \code{SccsDiagnosticThresholds} as created using
createSccsDiagnosticThresholds().}

\item{controlType}{Type of negative (and positive) controls. Can be "outcome" or
"exposure". When set to "outcome", controls with the
same exposure (and nesting cohort) are grouped together for
calibration. When set to "exposure", controls with the same
outcome are grouped together.}
}
\value{
An object of type \code{SccsAnalysesSpecifications}.
}
\description{
Create full SCCS analysis specifications
}
\details{
\subsection{Analyses to Exclude}{

Normally, \code{runSccsAnalyses} will run all combinations of exposures-outcome-analyses settings.
However, sometimes we may not need all those combinations. Using the \code{analysesToExclude} argument,
we can remove certain items from the full matrix. This argument should be a data frame with at least
one of the following columns:
\itemize{
\item exposureId
\item outcomeId
\item nestingCohortId
\item analysisId
}

This data frame will be joined to the outcome model reference table before executing, and matching rows
will be removed. For example, if one specifies only one exposure ID and analysis ID, then any analyses with
that exposure and that analysis ID will be skipped.
}
}
