% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qhc.R
\name{qhc}
\alias{qhc}
\title{Quantile of Higher Criticism statistics under the null hypothesis.}
\usage{
qhc(p, M, k0, k1, onesided = FALSE, method = "ecc", ei = NULL, err_thr = 1e-04)
}
\arguments{
\item{p}{-  a scalar left probability that defines the quantile.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{k0}{- search range starts from the k0th smallest p-value.}

\item{k1}{- search range ends at the k1th smallest p-value.}

\item{onesided}{- TRUE if the input p-values are one-sided.}

\item{method}{- default = "ecc": the effective correlation coefficient method in reference 2. "ave": the average method in reference 3, which is an earlier version of reference 2. The "ecc" method is more accurate and numerically stable than "ave" method.}

\item{ei}{- the eigenvalues of M if available.}

\item{err_thr}{- the error threshold. The default value is 1e-4.}
}
\value{
Quantile of HC statistics.
}
\description{
Quantile of Higher Criticism statistics under the null hypothesis.
}
\examples{
## The 0.05 critical value of HC statistic when n = 10:
qhc(p=.95, M=diag(10), k0=1, k1=5, onesided=FALSE)
qhc(p=1-1e-5, M=diag(10), k0=1, k1=5, onesided=FALSE, err_thr=1e-8)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and power of optimal signal-detection statistics in finite case", IEEE Transactions on Signal Processing (2020) 68, 1021-1033
2. Hong Zhang and Zheyang Wu. "The general goodness-of-fit tests for correlated data", Computational Statistics & Data Analysis (2022) 167, 107379
3. Hong Zhang and Zheyang Wu. "Generalized Goodness-Of-Fit Tests for Correlated Data", arXiv:1806.03668.
}
\seealso{
\code{\link{stat.hc}} for the definition of the statistic.
}
