% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{InteractiveSpatialPlot}
\alias{InteractiveSpatialPlot}
\title{Interactive Spatial Cell Selection Tool}
\usage{
InteractiveSpatialPlot(
  object,
  image = NULL,
  image.scale = "lowres",
  group.by = NULL,
  alpha = 1,
  pt.size.factor = 1,
  overlay_image = TRUE
)
}
\arguments{
\item{object}{A \code{\link[SeuratObject]{Seurat}} object with spatial data.}

\item{image}{Name of the spatial image stored in the object. If \code{NULL}, uses the default image for the object.}

\item{image.scale}{Character. Which image scaling factor to use for spatial coordinate transformation (\code{"lowres"} by default).}

\item{group.by}{Metadata variable (column name) to use for coloring cell points (e.g., cluster assignment). If \code{NULL}, uses \code{"seurat_clusters"} if available, otherwise all cells are grouped together.}

\item{alpha}{Numeric transparency value for cell points (default \code{1.0}).}

\item{pt.size.factor}{Numeric scaling factor for point size (default \code{1.0}).}

\item{overlay_image}{Logical; if \code{TRUE}, overlays the tissue image in the background of the plot (default \code{TRUE}).}
}
\value{
A character vector of cell names selected via lasso, which can be used to subset the object.
}
\description{
Launch an interactive gadget for lasso-based cell selection from a spatial Seurat object.
Supports Visium, SlideSeq, and Vizgen data. Returns the cell names of the selected subset,
suitable for downstream subsetting or analysis.
}
\note{
This function requires the
  \href{https://cran.r-project.org/package=plotly}{\pkg{plotly}},
  \href{https://cran.r-project.org/package=magrittr}{\pkg{magrittr}},
  and \href{https://cran.r-project.org/package=base64enc}{\pkg{base64enc}} packages
  to be installed. It also requires \pkg{shiny} and \pkg{miniUI} for the interactive UI.
}
\examples{
\dontrun{
selected_cells <- InteractiveSpatialPlot(object = brain)
selected_cells <- InteractiveSpatialPlot(object = brain, overlay_image = FALSE)
}
}
