% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.functions.R
\name{make.stepwise}
\alias{make.stepwise}
\title{Make a stepwise decay function}
\usage{
make.stepwise(probs, distances)
}
\arguments{
\item{probs}{Vector of dimension k, where k is the number of different probabilities of success. An individual time between (distances[i-1],distances[i]] has probability of success prob[i]}

\item{distances}{Vector of k, containing the end of each interval where success probabilities shift. The first interval where success is prob[1] is [0,distances[1]]. For all i>1, the probability of success is prob[i] over the interval (distance[i-1],distances[i]].}
}
\value{
An stepwise decay function
}
\description{
Create a stepwise decay function for genetic distance of two taxa and the probability of success of a hybridization event
}
\examples{
set.seed(17)
dist_func<- make.stepwise(probs=c(1,0.5,0),distances=c(0.25,0.5,Inf))
net<-sim.bdh.age(1,1,5,2,2,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),
hyb.rate.fxn=dist_func,complete=TRUE)[[1]]
}
