% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewBEVLogisticCopula.R
\name{NewBEVLogisticCopula}
\alias{NewBEVLogisticCopula}
\title{Creates a bivariate logistic model extreme value copula}
\usage{
NewBEVLogisticCopula(r)
}
\arguments{
\item{r}{real.}
}
\value{
A function that evaluates the bivariate logistic model EV copula (with parameter \eqn{r}) at a given \eqn{2}-dimensional vector in the unit square.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the bivariate asymmetric mixed model EV copula via automatic differentation.
}
\description{
Creates an instance of the bivariate logistic model extreme value copula with parameter \eqn{r}.
}
\details{
The dependence function for this bivariate EV copula is \deqn{A(w) = ((1-w)^r + w^r)^{1/r}}
Necessary and sufficient conditions for the dependence function to be valid are
\itemize{
  \item \eqn{r \ge 1}
}
}
\seealso{
\code{\link{NewBEVAsyLogisticCopula}}, \code{\link{NewMEVGumbelCopula}}
}
\author{
Berwin A. Turlach \email{berwin.turlach@gmail.com}
}
\keyword{distribution}
