% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_test.R
\name{sim_test}
\alias{sim_test}
\title{Bootstrap test for the assessment of similarity of drug dissolutions profiles via maximum deviation}
\usage{
sim_test(time1, time2 = time1, conc1, conc2, m1, m2, epsilon = 10,
  B = 1000, plot = FALSE)
}
\arguments{
\item{time1, time2}{vectors containing the time points of measurements for each of the two formulations; if not further specified the time points are identical in both groups}

\item{conc1, conc2}{data frames or matrices containing the concentrations obtained for each of the two formulations (see the example)}

\item{m1, m2}{model types. Built-in models are "firstorder",  "hixson",  "higuchi", "weibull" and "logistic"}

\item{epsilon}{positive argument specifying the equivalence threshold (in \%), default is 10\% corresponding to an f2 of 50 according to current guidelines}

\item{B}{number of bootstrap replications. If missing, default value of B is 1000}

\item{plot}{if TRUE, a plot of the absolute difference curve of the two estimated models will be given. The default is FALSE.}
}
\value{
A list containing the p.value, the types of models, the f2, the maximum absolute difference of the models, the estimated model parameters, the number of bootstrap replications and a summary of the bootstrap test statistic. Furthermore plots of the two models are given.
}
\description{
Function for testing whether two dissolution profiles are similar concerning the
hypotheses \eqn{H_0: \max_{t\in\mathcal{T}} |m_1(t,\beta_1)-m_2(t,\beta_2)|\geq \epsilon\ vs.\
H_1: \max_{t\in\mathcal{T}} |m_1(t,\beta_1)-m_2(t,\beta_2)|< \epsilon.}

$m_1$ and $m_2$ are pharmacokinetic models chosen from a candidate set containing a First order, Hixson-Crowell,Higuchi, Weibull and a logistic model.

See Moellenhoff et al. (2018) <doi:10.1002/sim.7689> for details.
}
\examples{
data(example_data)
conc1 <- select(filter(example_data,Group=="1"),-Tablet,-Group)
conc2 <- select(filter(example_data,Group=="2"),-Tablet,-Group)
time <- c(10,15,20,30,45,60)
sim_test(time1=time,time2=time,conc1=conc1,conc2=conc2,m1="logistic",m2="logistic",B=500,plot=TRUE)
}
\references{
Moellenhoff et al. (2018) <doi:10.1002/sim.7689>

EMA (2010) <https://www.ema.europa.eu/en/documents/scientific-guideline/guideline-investigation-bioequivalence-rev1_en.pdf>
}
