% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_method.R
\name{use_method}
\alias{use_method}
\title{Use a method}
\usage{
use_method(method, args = list())
}
\arguments{
\item{method}{A character string naming a function that has been declared or
loaded via \code{source}.}

\item{args}{A list of arguments to be passed onto \code{method}}
}
\value{
The result of the call to \code{method}
}
\description{
This function calls the specified method, passing along any
    arguments that have been specified in \code{args}. It will typically be
    used in conjunction with the special object L to dynamically run methods
    that have been included as simulation levels. This function is a wrapper
    around do.call and is used in a similar manner. See examples.
}
\examples{
# The following is a toy example of a simulation, illustrating the use of
# the use_method function.
sim <- new_sim()
create_data <- function(n) { rpois(n, lambda=5) }
est_mean_1 <- function(dat) { mean(dat) }
est_mean_2 <- function(dat) { var(dat) }
sim \%<>\% set_levels(
  "n" = c(10, 100, 1000),
  "estimator" = c("est_mean_1", "est_mean_2")
)
sim \%<>\% set_config(num_sim=1)
sim \%<>\% set_script(function() {
  dat <- create_data(L$n)
  lambda_hat <- use_method(L$estimator, list(dat))
  return (list("lambda_hat"=lambda_hat))
})
sim \%<>\% run()
sim$results
}
