% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simssfixed.R
\name{simssfixed}
\alias{simssfixed}
\title{Simulatng SSRT data using fixed SSD methods}
\usage{
simssfixed(pid, block, n, m, SSD.b, dist.go, theta.go, dist.stop, theta.stop)
}
\arguments{
\item{pid}{character vector of size \code{b} of participant}

\item{block}{numeric vector of size \code{b} blocks}

\item{n}{numeric vector of size \code{b} of total number of trials}

\item{m}{numeric vector of size \code{b} of total number of stops}

\item{SSD.b}{numeric vector of size \code{b} of stop signal delay}

\item{dist.go}{character vector of size \code{b} of distribution of go trials, either ExG or SW}

\item{theta.go}{numeric matrix of size \code{b} by columns of \code{mu.go}, \code{sigma.go}, and \code{tau.go}}

\item{dist.stop}{character vector of size \code{b} of distribution of stop.trials, either ExG or SW}

\item{theta.stop}{numeric matrix of size \code{b} by columns of \code{mu.stop}, \code{sigma.stop}, and \code{tau.stop}}
}
\value{
matrix with \code{sum(n)} rows and 8 columns
}
\description{
Stop signal task data of go and stop trials is generated per participant. The fixed stop signal delay method with underlying exponentially modified Gaussian (ExG) or Shifted Wald (SW) distributions for each of go and stop process is applied. The output data can be converted to 'BEESTS' software input data enabling researchers to test and evaluate different distributional parameters of interest.
}
\examples{
mySSTdata1 <- simssfixed(
 pid = c("John.Smith","Jane.McDonald","Jane.McDonald"),
 n = c(50,100,150), m=c(10,20,30), SSD.b=c(200,220,240),
 dist.go=c("ExG","ExG","ExG"),
 theta.go=as.matrix(rbind(c(400,60,30),c(440,90,90),c(440,90,90))),
 dist.stop=c("ExG","ExG","ExG"),
 theta.stop=as.matrix(rbind(c(100,70,60),c(120,80,70),c(120,80,70))),
 block=c(1,1,2))
mySSTdata1

}
\references{
Gordon D. Logan. On the Ability to Inhibit Thought and Action: A User's Guide to the Stop Signal Paradigm. In D. Dagenbach, & T.H. Carr (Eds.), Inhibitory Process in Attention, Memory and Language. San Diego: Academic Press, 1994.

Dora Matzke, Jonathon Love, Thomas V. Wiecki, Scott D. Brown, and et al. Release the BEESTS: Bayesian Estimation of Ex-Gaussian Stop Signal Reaction Times Distributions. Frontiers in Psychology, 4: Article 918, 2013.

Mohsen Soltanifar. Stop Signal Reaction Times: New Estimations with Longitudinal, Bayesian and Time  Series based Methods, PhD Dissertation, Biostatistics Division, Dalla Lana School of Public Health, University of Toronto, Toronto, Canada, 2020.
}
