% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Kobe.R
\docType{class}
\name{Kobe-class}
\alias{Kobe-class}
\title{S4 class Kobe}
\description{
Slots can be accessed and assigned using functions corresponding to slot name.
See \verb{See Also} section below.
}
\details{
Objects of class \code{Kobe} are created with \code{Kobe()}
\subsection{Performance Indicators}{

By default, the first PI will be on the x-axis (usually B/BMSY or something similar) and the second
on the y-axis (e.g., F/FMSY). The Slick \code{\link[=App]{App()}} provides drop down menus for selecting other PIs.
}

\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in \code{Value}
}
}
\section{Slots}{

\describe{
\item{\code{Code}}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Label}}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Description}}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Time}}{A numeric vector with values for the projection time-steps. Must
match length \code{nTS} in \code{Value}}

\item{\code{TimeLab}}{Character string length 1. Name of the time step (e.g., 'Year'). Will be used as the label in the \verb{Kobe Time} plot. Use a named list for
multiple languages.}

\item{\code{Value}}{A numeric array with the stochastic performance indicator values for each
simulation (sim), operating model (OM), management procedure (MP), performance indicator (PI),
and projection time-steps (nTS)
Dimensions: c(\code{nsim}, \code{nOM}, \code{nMP}, \code{nPI}, \code{nTS})}

\item{\code{Preset}}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{\code{Target}}{Numeric vector length \code{nPI} with the target value for the PIs. Defines the color quadrants on the Kobe plot.
Defaults to 1.}

\item{\code{Limit}}{Numeric vector length \code{nPI} with the limit value for the two PIs. Shows as red line on Kobe plot. NULL to ignore.}

\item{\code{Defaults}}{A list object with default selections for the Kobe See \code{\link[=Kobe]{Kobe()}}}

\item{\code{TimeTerminal}}{Optional. By default the \code{Kobe} plot shows the terminal projection year.
\code{TimeTerminal} can be used to override this. Use a numeric value indicating the time (must match a value in \code{Time}) to use
for the \code{Kobe} plot}
}}

\examples{
# Generate dummy values
nsim <- 10
nOM <- 2
nMP <- 4
nPI <- 2
nTS <- 30

values <- array(NA, dim=c(nsim, nOM, nMP, nPI, nTS))

pi_means <- c(1,1)

for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[,om, mp, pi,] <- pi_means[pi] *
        matrix(
        cumprod(c(rlnorm(nTS*nsim, 0, 0.05))),
        nrow=nsim)
    }
  }
}

# Create and populate Object
kobe <- Kobe(Code=c('B/BMSY', 'F/FMSY'),
             Label=c('B/BMSY',
                     'F/FMSY'),
             Description = c('This is the description for PI 1',
                             'This is the description for PI 2'),
             Value=values
)

# Add values for projection time steps
Time(kobe) <- seq(2025, by=1, length.out=nTS)

# Check
Check(kobe)

# Add to `Slick` object
slick <- Slick()
Kobe(slick) <- kobe

# Plots
plotKobe(slick)

plotKobe(slick, Time=TRUE)

}
\seealso{
\code{\link[=Kobe]{Kobe()}}, \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}},
\code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}}
}
