% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Boxplot.R
\docType{class}
\name{Boxplot-class}
\alias{Boxplot-class}
\title{\code{Boxplot} S4 Object Class}
\description{
Objects of class \code{Boxplot} are used to store information for the Boxplot and Violin plots.
Like all S4 objects in \code{Slick}, slots in this object can be accessed and
assigned using functions corresponding to slot name. See \code{\link[=Boxplot]{Boxplot()}} and the
the \verb{See Also} section below.
}
\details{
Objects of class \code{Boxplot} are created with \code{Boxplot()}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in \code{Value}
}
}
\section{Slots}{

\describe{
\item{\code{Code}}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Label}}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Description}}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Value}}{A numeric array with the stochastic performance indicator values for each
simulation (sim), operating model (OM), management procedure (MP), and performance indicator (PI).
Dimensions: c(\code{nsim}, \code{nOM}, \code{nMP}, and \code{nPI}).}

\item{\code{Preset}}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{\code{Defaults}}{A list object with default selections for the Boxplot. See \code{\link[=Boxplot]{Boxplot()}}}

\item{\code{Misc}}{A named list for additional miscellaneous information.}
}}

\examples{
# Generate dummy values
nsim <- 10
nOM <- 2
nMP <- 4
nPI <- 3

values <- array(NA, dim=c(nsim, nOM, nMP, nPI))
pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[,om, mp, pi] <- rlnorm(nsim, log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
boxplot <- Boxplot(Code=c('PI1', 'PI2', 'PI3'),
                   Label=c('Performance Indicator 1',
                           'Performance Indicator 2',
                           'Performance Indicator 3'),
                   Description = c('This is the description for PI 1',
                                   'This is the description for PI 2',
                                   'This is the description for PI 3'),
                   Value=values)

# Check
Check(boxplot)

# Add to `Slick` object
slick <- Slick()
Boxplot(slick) <- boxplot

# Plots
plotBoxplot(slick)

plotBoxplot(slick, type='violin')

plotBoxplot(slick, byOM=TRUE)

plotBoxplot(slick, 2, type='both', byOM=TRUE)

}
\seealso{
\code{\link[=Boxplot]{Boxplot()}}, \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}},
\code{\link[=Metadata]{Metadata()}}, \code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}}
}
