% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_Spider.R,
%   R/class_Slick.R
\docType{methods}
\name{Spider}
\alias{Spider}
\alias{Spider<-}
\alias{Spider,missing-method}
\alias{Spider,character-method}
\alias{Spider,list-method}
\alias{Spider,Slick-method}
\alias{Spider<-,Slick-method}
\title{Methods for Creating, Accessing and Assigning \code{Spider} objects}
\usage{
Spider(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list(),
  Misc = list()
)

Spider(Slick) <- value

\S4method{Spider}{missing}()

\S4method{Spider}{character}(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list(),
  Misc = list()
)

\S4method{Spider}{list}(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list(),
  Misc = list()
)

\S4method{Spider}{Slick}(Code)

\S4method{Spider}{Slick}(Slick) <- value
}
\arguments{
\item{Code}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Label}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Description}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Value}{A numeric array with the stochastic performance indicator values for each
operating model (OM), management procedure (MP), and performance indicator (PI).
Dimensions: c(\code{nOM}, \code{nMP}, and \code{nPI}).
All PI values must range between 0 and 1 or 0 and 100. If all values are <= 1, they will be
multiplied by 100 in the plot.}

\item{Preset}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{Misc}{A named list for additional miscellaneous information.}

\item{Slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{value}{A \code{\link[=Spider-class]{Spider-class()}} object}
}
\description{
The \code{Spider} function is used both to create and modify an \code{\link[=Spider-class]{Spider-class()}} object.
and to access and assign \code{Spider} for an object of class \code{\link[=Slick-class]{Slick-class()}}.
See \code{Details}.
}
\details{
Objects of class \code{Spider} are created with \code{Spider()}

Use the  \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}} functions to
access and assign the values for an existing \code{Spider} object, see \code{Examples}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in `Value
}
}
\section{Functions}{
\itemize{
\item \code{Spider(missing)}: Create an empty \code{Spider} object

\item \code{Spider(character)}: Create a populated \code{Spider} object

\item \code{Spider(list)}: Create a populated \code{Spider} object

\item \code{Spider(Slick)}: Return \code{Spider} from a \code{\link[=Slick-class]{Slick-class()}} object

\item \code{Spider(Slick) <- value}: Assign a \code{\link[=Spider-class]{Spider-class()}} object to a \code{\link[=Slick-class]{Slick-class()}} object

}}
\examples{
# Generate dummy values
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nOM, nMP, nPI))

# Note: PI values must be between 0 and 1, with 1 indicating better performance
pi_means <- runif(nPI, 0, 1)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[om, mp, pi] <- runif(1, pi_means[pi])
    }
  }
}

# Create and populate Object
spider <- Spider(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)

# Check
Check(spider)

# Add to `Slick` object
slick <- Slick()
Spider(slick) <- spider

# Plots
plotSpider(slick)

plotSpider(slick, fill=TRUE)

plotSpider(slick, byMP=TRUE)

plotSpider(slick, byOM=TRUE)

}
\seealso{
\code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Metadata]{Metadata()}}, \code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}}
}
