% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fFitSmithWilsonYieldCurveToInstruments.R
\name{fFitSmithWilsonYieldCurveToInstruments}
\alias{fFitSmithWilsonYieldCurveToInstruments}
\title{Construct the Smith-Wilson yield curve}
\usage{
fFitSmithWilsonYieldCurveToInstruments(InstrumentSet, ufr, alpha)
}
\arguments{
\item{InstrumentSet}{A set of market instruments as a dataframe with columns
\itemize{
 \item "Type" One of (LIBOR, SWAP, BOND) 
    \item "Tenor" The instrument maturity in years
    \item "Frequency" The payment frequency (ignored for Type=="LIBOR" )
     \item "Rate" The coupon rate per annum in percent
     \item "Price"The price per unit nominal for a bond
}}

\item{ufr}{The Ultimate Forward Rate (UFR) of the Smith-Wilson kernel}

\item{alpha}{The rate of reversion of forward rates to the UFR in the Smith-Wilson kernel}
}
\value{
a list containing:
\itemize{
 \item "P" a function of time which gives the ZCB price to that term 
 \item "xi" the vector of weights applied to the kernel functions to obtain the ZCB price 
 \item "K" the (compound) kernel vector 
}
}
\description{
Constructs the SmithWilson ZCB function based on the given market inputs and parameter choices.
Primarily a convenience wrapper around other package functions
}
