#' Cholera Cases Dataset
#'
#' A dataset containing the locations of cholera cases in 1854 Soho, London
#'
#' @format A data frame with 5 rows and 317 columns:
#' \describe{
#'   \item{id}{Observation-level identifier}
#'   \item{Count}{Count of cholera deaths}
#'   \item{Angle}{Variable used for aligning barcharts along streets, for use when re-creating the barchart approach of John Snow}
#'   \item{Easting}{X-coordinate in Ordnance Survey National Grid (OSGB36) projection}
#'   \item{Northing}{Y-coordinate in Ordnance Survey National Grid (OSGB36) projection}
#' }
#' @source John Snow's 1854 cholera outbreak map, georeferenced and processed by Niamh Mimnagh.
#' Original map and data can be found in the public domain at: Snow, J. (1855). On the Mode of Communication of Cholera. (Online) Available: https://commons.wikimedia.org/wiki/File:Snow-cholera-map-1.jpg


#' @usage data(cholera_cases)
#' @keywords datasets
"cholera_cases"

#' Water Pump Locations Dataset
#'
#' A dataset containing the locations of water pumps in 1854 Soho, London
#'
#' @format A data frame with 3 rows and 13 columns:
#' \describe{
#'   \item{id}{Observation-level identifier}
#'   \item{Easting}{X-coordinate in Ordnance Survey National Grid (OSGB36) projection}
#'   \item{Northing}{Y-coordinate in Ordnance Survey National Grid (OSGB36) projection}
#' }
#' @source John Snow's 1854 cholera outbreak map, georeferenced and processed by Niamh Mimnagh.
#' Original map and data can be found in the public domain at: Snow, J. (1855). On the Mode of Communication of Cholera. (Online) Available: https://commons.wikimedia.org/wiki/File:Snow-cholera-map-1.jpg
#' @usage data(pump_locations)
#' @keywords datasets
"pump_locations"

#' Streets Dataset
#'
#' A dataset containing the start-points and end-points of streets in 1854 Soho, London
#'
#' @format A data frame with 5 rows and 317 columns:
#' \describe{
#'   \item{id}{Observation-level identifier}
#'   \item{dist}{Length of street section in metres}
#'   \item{start_point}{Street start-point identifier}
#'   \item{end_point}{Street end-point identifier}
#'   \item{start_coord_east}{X-coordinate in Ordnance Survey National Grid (OSGB36) projection of the start-point}
#'   \item{start_coord_north}{Y-coordinate in Ordnance Survey National Grid (OSGB36) projection of the start-point}
#'   \item{end_coord_east}{X-coordinate in Ordnance Survey National Grid (OSGB36) projection of the end-point}
#'    \item{end_coord_north}{Y-coordinate in Ordnance Survey National Grid (OSGB36) projection of the end-point}
#' }
#' @source John Snow's 1854 cholera outbreak map, georeferenced and processed by Niamh Mimnagh.
#' Original map and data can be found in the public domain at: Snow, J. (1855). On the Mode of Communication of Cholera. (Online) Available: https://commons.wikimedia.org/wiki/File:Snow-cholera-map-1.jpg
#' @usage data(streets)
#' @keywords datasets
"streets"


#' Map TIF File
#'
#' A geospatial dataset for John Snow's original map
#'
#' @source John Snow's 1854 cholera outbreak map, georeferenced and processed by Niamh Mimnagh.
#' Original map and data can be found in the public domain at: Snow, J. (1855). On the Mode of Communication of Cholera. (Online) Available: https://commons.wikimedia.org/wiki/File:Snow-cholera-map-1.jpg
#' @usage load_map()


