% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_simmer_wrappers.R
\name{sobol4r_clinic_model}
\alias{sobol4r_clinic_model}
\title{Two-step clinic model wrapper for Sobol designs}
\usage{
sobol4r_clinic_model(
  X,
  cap_reg = 2,
  cap_exam = 3,
  horizon = 2000,
  warmup_prob = 0.2,
  nrep = 10L
)
}
\arguments{
\item{X}{Design matrix or data.frame with columns \code{lambda} (arrival
rate), \code{mu_reg} (registration service rate), and \code{mu_exam}
(examination service rate).}

\item{cap_reg, cap_exam}{Integer capacities for the registration and
examination resources.}

\item{horizon}{Simulation horizon.}

\item{warmup_prob}{Fraction of the horizon treated as warmup and discarded
before computing the mean time in system.}

\item{nrep}{Number of replications used to average the mean time in system.}
}
\value{
Numeric vector of length \code{nrow(X)}.
}
\description{
Simulate a simple clinic with separate registration and examination stages
using \pkg{simmer}. The quantity of interest is the mean time in system over
\code{nrep} replications for each parameter set.
}
