% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{DTPA_Micro}
\alias{DTPA_Micro}
\title{Available micronutrient cations in soil}
\usage{
DTPA_Micro(W = W, VE = VE, VA = VA, VF = VF, S = S, B =  B)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{VE}{Volume of extractant solution (mL)}

\item{VA}{Volume of aliquot of the extract (mL)}

\item{VF}{Volume of final solution fed to AAS (mL)}

\item{S}{Concentration of the micronutrient cation (mg/L) in final solution (test sample) as obtained from the AAS}

\item{B}{Concentration of the micronutrient cation (mg/L) in the blank solution as obtained from the AAS}
}
\value{
Micro_mgkg - Available micronutrient cation in soil (mg/kg)
Micro_kgha - Available micronutrient cation in soil (kg/ha)
}
\description{
The content of available or DTPA (diethylene triamine penta-acetic acid) extractable micronutrient cations e.g., iron (Fe), manganese (Mn), zinc (Zn), copper (Cu), and nickel (Ni) can be obtained by this function based on AAS reading.
}
\details{
Plant available cationic micronutrients i.e., Fe, Mn, Zn, Cu, and Ni in soils are commonly extracted by DTPA extractant i.e., 0.005 M DTPA + 0.1 M TEA + 0.01 M CaCl2, pH 7.3; and determined by an AAS directly, or after dilution if needed (Lindsay and Norvell, 1978; Datta et al., 2019). In case of no additional dilution after extraction, the values of VA and VF should be put as 1.
}
\examples{
with(data = df_DTPA_Micro, DTPA_Micro(W = Mass_Soil, VE = Vol_Extractant,
VA = Vol_Aliquot, VF = Vol_Final, S = AAS_Sample, B =  AAS_Blank))

}
\references{
Datta, S.P., Golui, D., Barman, M., Meena, M.C., Shukla, S.K. and Trivedi, V.K. (2019) Determination of micronutrients and pollutant elements in soil. In Soil Analysis (S.K. Singh et al. (Eds.), Indian Society of Soil Science, New Delhi.

Lindsay, W.L. and Norvell, W.A. (1978) DTPA soil test method for determining available zinc, iron, manganese and copper. Soil Science Society of America Journal 42, 421-428.
}
