# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate AUC and its sampling standard deviation (Internal C++ implementation)
#' 
#' @param fcst numeric vector of forecasts (NAs are not allowed)
#' @param obs vector of binary observations (obs[t] evaluates to TRUE if event happens at instance t, to FALSE otherwise) 
#' @return AUC and its sampling standard deviation
#' @seealso Auc AucDiff
#' @export
auc_cpp <- function(fcst, obs) {
    .Call(`_SpecsVerification_auc_cpp`, fcst, obs)
}

#' Calculate AUC difference `AUC(fcst,obs) - AUC(fcst_ref, obs)` of two forecasts for the same observations, and the sampling standard deviation of the AUC difference (Internal C++ implementation)
#' 
#' @param fcst numeric vector of forecasts (NAs are not allowed)
#' @param fcst_ref numeric vector of reference forecasts (NAs are not allowed)
#' @param obs vector of binary observations (obs[t] evaluates to TRUE if event happens at instance t, to FALSE otherwise) 
#' @return AUC values, their sampling standard deviations, the AUC difference, and their sampling standard deviations
#' @seealso Auc AucDiff
#' @export
aucdiff_cpp <- function(fcst, fcst_ref, obs) {
    .Call(`_SpecsVerification_aucdiff_cpp`, fcst, fcst_ref, obs)
}

#' Dress CRPS
#'
#' @param m vector of kernel means
#' @param s vector of kernel standard deviations
#' @param y observation 
#' @return crps
#' @export
dresscrps_cpp <- function(m, s, y) {
    .Call(`_SpecsVerification_dresscrps_cpp`, m, s, y)
}

#' CRPS for ensemble forecasts (C++ implementation)
#'
#' @param ens Ensemble members as columns of a matrix
#' @param obs The verifying observations
#' @param R_new Size for ensemble adjustment
#'
#' @return vector of crps values
#' @export
enscrps_cpp <- function(ens, obs, R_new) {
    .Call(`_SpecsVerification_enscrps_cpp`, ens, obs, R_new)
}

