% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emplogitplot1.r
\name{emplogitplot1}
\alias{emplogitplot1}
\title{Empirical logit plot for one quantitative variable}
\usage{
emplogitplot1(formula, data = NULL, ngroups = 3, breaks = NULL,
  yes = NULL, padj = TRUE, out = FALSE, showplot = TRUE,
  showline = TRUE, ylab = "Log(Odds)", xlab = NULL,
  dotcol = "black", linecol = "blue", pch = 16, main = "",
  ylim = NULL, xlim = NULL, lty = 1, lwd = 1, cex = 1)
}
\arguments{
\item{formula}{A formula of the form (binary) Response~Predictor}

\item{data}{A dataframe}

\item{ngroups}{Number of groups to use (not needed if breaks is used), ngroups="all" uses all unique values}

\item{breaks}{A vector of endpoints for the bins (not needed if ngroups is used)}

\item{yes}{Set a value for the response to be counted for proportions (optional)}

\item{padj}{Should proportions be adjusted to avoid zero and one? (default is TRUE)}

\item{out}{Should the function return a dataframe with group information? (default is FALSE)}

\item{showplot}{Show the plot? default is TRUE}

\item{showline}{Show the regression line? default is TRUE}

\item{ylab}{Text label for the vertical axis (default is "Log(Odds)")}

\item{xlab}{Text label for the horizontal axis (default is NULL)}

\item{dotcol}{Color for the dots (default is "black")}

\item{linecol}{Color for the line (default is "black")}

\item{pch}{Plot character for the dots (default is 16)}

\item{main}{Title for plot}

\item{ylim}{Limits for the vertical axis}

\item{xlim}{Limits for the horizontal axis}

\item{lty}{Line type (default is 1)}

\item{lwd}{Line width (default is 1)}

\item{cex}{Multiplier for plot symbols}
}
\value{
A dataframe with group information (if out=TRUE)
}
\description{
This function produces an empirical logit plot for a binary response variable and a
single quantitative predictor variable.
}
\details{
Values of the quantitative explanatory variable will be grouped into \code{ngroups}
roughly equal sized groups, unless \code{breaks} is used to determine the boundaries of the groups.
Using \code{ngroups="all"} will make each distinct value of the explanatory variable its own group \cr

We find an adjusted proportion for the binary response variable within each of the groups with
\code{(Number yes +0.5)/(Number of cases+1)}. This is converted to an adjusted log odds
\code{log(adjp/(1-adjp))}.  The adjustment avoids problems if there are no "successes" or
all "successes" in a group.  What constitutes a "success" can be specified with \code{yes=}
and the proportion adjustment can be turned off (if no group proportions are likely to be zero or one)
with \code{padj=FALSE}.\cr

The function plots the log odds versus the mean of the explanatory variable within each group.
 A least square line is fit to these points.  The plot can be suppressed with \code{showplot=FALSE}.\cr

 The \code{out=TRUE} option will return a dataframe with the boundaries of each group, proportion,
 adjusted proportion, mean explanatory variable, and (adjusted or unadjusted) log odds.
}
\examples{
data(MedGPA)
emplogitplot1(Acceptance~GPA,data=MedGPA)

GroupTable=emplogitplot1(Acceptance~MCAT,ngroups=5,out=TRUE,data=MedGPA)

emplogitplot1(Acceptance~MCAT,data=MedGPA,breaks=c(0,34.5,39.5,50.5),dotcol="red",linecol="black")

data(Putts1)
emplogitplot1(Made~Length,data=Putts1,ngroups="all")

}
