% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chi_Var_ci_no_data.R
\name{chi_var_ci_no_data}
\alias{chi_var_ci_no_data}
\title{Compute Confidence Interval for Variance Without Raw Data}
\usage{
chi_var_ci_no_data(s2_given, n_given, conf_level)
}
\arguments{
\item{s2_given}{Numeric. The sample variance.}

\item{n_given}{Integer. The sample size.}

\item{conf_level}{Numeric. The confidence level (e.g., 0.95 for 95\% CI).}
}
\value{
A numeric vector with the lower and upper bounds of the confidence interval.
}
\description{
This function calculates the confidence interval for variance when only + the sample variance and sample size are known.
}
\examples{
s2_given <- 21.5   # Sample variance
n_given <- 26      # Sample size
conf_level <- 0.98 # 98\% confidence level
chi_var_ci_no_data(s2_given, n_given, conf_level)
}
