% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovarianceM.R
\name{CovarianceM}
\alias{CovarianceM}
\title{Covariance matrix for spatio-temporal model}
\usage{
CovarianceM(phi, rho, tau2, sigma2, distSpa, disTemp, kappa, type.S)
}
\arguments{
\item{phi}{value of the spatial scaling parameter.}

\item{rho}{value of the time scaling parameter.}

\item{tau2}{value of the the nugget effect parameter.}

\item{sigma2}{value of the partial sill.}

\item{distSpa}{\eqn{n x n} spatial distance matrix without considering repetitions.}

\item{disTemp}{\eqn{T x T} temporal distance matrix without considering repetitions.}

\item{kappa}{parameter for all spatial covariance functions. In the case of exponential, gaussian and spherical function \eqn{\kappa} is equal to zero.
For the power exponential function \eqn{\kappa} is a number between 0 and 2. For the matern correlation function is upper than 0.}

\item{type.S}{type of spatial correlation function: '\code{exponential}' for exponential, '\code{gaussian}' for gaussian,
'\code{matern}' for matern, '\code{pow.exp}' for power exponential and '\code{spherical}' for spherical function, respectively.
See the analytical form of these functions in \code{\link{EffectiveRange}}.}
}
\value{
The function returns the \eqn{nT x nT} spatio-temporal covariance matrix for balanced data.
}
\description{
It computes the spatio-temporal covariance matrix for balanced data, i.e., when we have the same temporal indexes
per location. To compute the spatial correlation it provides 5 functions: exponential, gaussian, matern,
spherical and power exponential. To compute the temporal correlation is used an autocorrelation function of an AR(1) process.
}
\examples{
set.seed(1000)
# Parameter values
phi  <- 5
rho  <- 0.45
tau2 <- 0.80
sigma2 <- 2

# Coordinates and time points
coords <- matrix(runif(20, 0, 10), ncol=2) # Cartesian coordinates without repetitions
time   <- as.matrix(1:5)   # Time index without repetitions
Ms <- as.matrix(dist(coords)) # Spatial distances
Mt <- as.matrix(dist(time))   # Temporal distances

# Covariance matrix
Cov <- CovarianceM(phi, rho, tau2, sigma2, distSpa=Ms, disTemp=Mt,
                   kappa=0, type.S="exponential")
}
\author{
Katherine L. Valeriano, Victor H. Lachos and Larissa A. Matos
}
