% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffectiveRange.R
\name{EffectiveRange}
\alias{EffectiveRange}
\title{Effective range for some spatial correlation functions}
\usage{
EffectiveRange(cor = 0.05, phi, kappa = 0, Sp.model = "exponential")
}
\arguments{
\item{cor}{effective correlation to check for. By default = 0.05.}

\item{phi}{spatial scaling parameter.}

\item{kappa}{smoothness parameter, required by the matern and power exponential functions. By default = 0.}

\item{Sp.model}{type of spatial correlation function: '\code{exponential}' for exponential,
'\code{gaussian}' for gaussian, '\code{matern}' for matern, '\code{pow.exp}' for power
exponential and '\code{spherical}' for spherical function, respectively. By default = \code{exponential}.}
}
\value{
The function returns the effective range, i.e., the approximate distance from which the
spatial correlation is lower than \code{cor}.
}
\description{
It computes the effective range for an isotropic spatial correlation function, which is
commonly defined to be the distance from which the correlation becomes small, typically
below 0.05.
}
\details{
The available isotropic spatial correlation functions are:

\describe{
\item{\strong{Exponential}:}{\eqn{Corr(d) = exp{-d/\phi}},}

\item{\strong{Gaussian}:}{\eqn{Corr(d) = exp{-(d/\phi)^2}},}

\item{\strong{Matern}:}{\eqn{Corr(d) = 1/(2^(\kappa-1)\Gamma(\kappa))(d/\phi)^\kappa K_\kappa(d/\phi)},}

\item{\strong{Power exponential}:}{\eqn{Corr(d) = exp{-(d/\phi)^\kappa}},}

\item{\strong{Spherical}:}{\eqn{Corr(d) = 1 - 1.5 d/\phi + 0.5(d/\phi)^3},}

where \eqn{d} is the Euclidean distance between two observations, \eqn{\phi} is the spatial scaling
parameter, \eqn{\Gamma(.)} is the gamma function, \eqn{\kappa} is the smoothness parameter and
\eqn{K_\kappa(.)} is the modified Bessel function of the second kind of order \eqn{\kappa}.
}
}
\examples{
phi <- 164.60
range1 <- EffectiveRange(0.05, phi, kappa=0, Sp.model="exponential")
range2 <- EffectiveRange(0.05, phi, kappa=1, Sp.model="pow.exp")
# Note that these functions are equivalent.
}
\author{
Katherine L. Valeriano, Victor H. Lachos and Larissa A. Matos
}
