% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter}
\alias{filter}
\title{filter}
\usage{
filter(
  data,
  type = "c",
  yvar,
  xvars,
  censorvar = NULL,
  trtvar = NULL,
  trtref = 1,
  n.boot = 50,
  cv.iter = 20,
  pre.filter = length(xvars),
  filter.method = NULL
)
}
\arguments{
\item{data}{input data frame}

\item{type}{type of response variable: "c" continuous; "s" survival; "b" binary}

\item{yvar}{variable (column) name for response variable}

\item{xvars}{vector of variable names for predictors (covariates)}

\item{censorvar}{variable name for censoring (1: event; 0: censor), default = NULL}

\item{trtvar}{variable name for treatment variable, default = NULL (prognostic signature)}

\item{trtref}{coding (in the column of trtvar) for treatment arm, default = 1 (no use for prognostic signature)}

\item{n.boot}{number of bootstrap for the BATTing procedure}

\item{cv.iter}{Algotithm terminates after cv.iter successful iterations of cross-validation, or after max.iter total iterations, whichever occurs first}

\item{pre.filter}{NULL (default), no prefiltering conducted;"opt", optimized number of predictors selected; An integer: min(opt, integer) of predictors selected}

\item{filter.method}{NULL (default), no prefiltering; "univariate", univaraite filtering; "glmnet", glmnet filtering}
}
\value{
\item{var}{a vector of filter results of variable names}
}
\description{
Filter function for Prognostic and preditive biomarker signature development for Exploratory Subgroup Identification in Randomized Clinical Trials
}
\details{
Filter function for predictive/prognostic biomarker candidates for signature development

The function contains two algorithms for filtering high-dimentional multivariate (prognostic/predictive) biomarker candidates via univariate fitering (used p-values of group difference for prognostic case, p-values of interaction term for predictive case); LASSO/Elastic Net method. (Tian L. et al 2012)
}
\examples{
# no run
}
\references{
Tian L, Alizadeh A, Gentles A, Tibshirani R (2012) A Simple Method for Detecting Interactions between a Treatment and a Large Number of Covariates. J Am Stat Assoc. 2014 Oct; 109(508): 1517-1532.
}
