############################################
### SIMEX for the additive hazards model ###
############################################

SIMEX_S2_AH = function(surv, status, X, Sigma_e, Psi, K) {   # Step 2 in SIMEX algorithm
GAMMA_Psi = NULL

for(psi in 1 : length(Psi)) {
G_coll = NULL                   # collection for all k in the following loop

for(k in 1 : length(K)) {

GAMMA_psi_k = SIMEX_S1_AH(surv, status, X, Sigma_e, Psi[psi], K[k])

G_coll = rbind(G_coll, GAMMA_psi_k)

}
GAMMA_Psi[[psi]] = G_coll

}

return(GAMMA_Psi)

}

SIMEX_AH = function(surv, status, X, Sigma_e, Psi, K, order) {  # Step 3 in SIMEX algorithm
p = dim(X)[2]
result = SIMEX_S2_AH(surv, status, X, Sigma_e, Psi, K)

vt = NULL
for(psi in 1:length(Psi)) {

vt = rbind(vt,colMeans(result[[psi]]))

}

B = rep(1,length(Psi))
ext = 1
for(o in 1:order) {
B = cbind(B,Psi^o)
ext = c(ext, (-1)^o)
}

beta = solve(t(B)%*%B) %*% (t(B)%*%vt)



output = as.vector(ext %*%beta)

beta_estimator = output[1:p]
theta_estimator = matrix(output[-c(1:p)],p,p)
for(i in 1:p) {
for(j in 1:i) {
theta_estimator[i,j] = max(theta_estimator[i,j],theta_estimator[j,i])
theta_estimator[j,i] = max(theta_estimator[i,j],theta_estimator[j,i])
}
}

estimator = list(beta_estimator, theta_estimator)
names(estimator) = c("est_beta", "est_theta")

return(estimator)

}
