\name{VS_network}
\alias{VS_network}
\title{
Reporting the estimation results and displaying the network structure
}
\description{
This function reports the selected covariates and displays the estimated network structure.
}
\usage{
VS_network(beta,theta,labels,label.sizes,node.size)
}
\arguments{
  \item{beta}{An estimate of \eqn{\widehat{\boldsymbol{\beta}}} derived from the functions \code{SIMEX_PH}, \code{SIMEX_AH}, \code{SIMEX_AFT}, and \code{SIMEX_TM}}
  \item{theta}{An estimate of \eqn{\widehat{\boldsymbol{\Theta}}} derived from the functions \code{SIMEX_PH}, \code{SIMEX_AH}, \code{SIMEX_AFT}, and \code{SIMEX_TM}}
  \item{labels}{A list of covariates names. By defaults, positive numerical labels are used. }
  \item{label.sizes}{A positive integer displaying the size of labels. The default is 6. }
  \item{node.size}{A positive integer displaying the size of nodes in the network. The default is 6.}

}


\details{
This function summarizes the selected covariates and displays the estimated network structure for visualization.
}

\value{
\item{selected_variables}{A list of printed names of selected variables}
\item{graph}{An estimated network structure}
}

\references{
Chen, L.-P. and Yi, G. Y. (2021). Analysis of noisy survival data with graphical proportional hazards measurement error models. \emph{Biometrics}, 77, 956–969.
}

\author{
Chen, L.-P. and Yi, G. Y.
}



\examples{
library(MASS)
library(glmnet)
library(survival)
library(ahaz)
library(network)
library(sna)
library(scales)
set.seed(2025)
n = 200
p = 4
Z = mvrnorm(n,rep(0,p), diag(1,p))
T = exp(Z[,1]+Z[,2]+Z[,3]*Z[,4] + runif(n,0,1))
C = rexp(n,1)
Y = pmin(T,C)
delta = (T<C)*1
SA = diag(c(0,0.6,0,0.6),dim(Z)[2])
X = Z + mvrnorm(n,rep(0,p), SA)

est_PH = SIMEX_PH(Y, delta, X, Sigma_e = SA, Psi = seq(0,1,length=5), K=10, order=2)


VS_network(est_PH$est_beta, est_PH$est_theta,
            label.sizes=4, node.size=6)
}


\keyword{funtion}
\keyword{core}
