% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPweights.R
\name{cdfDT}
\alias{cdfDT}
\title{Distribution function estimation under double truncation}
\usage{
cdfDT(
  y,
  l,
  r,
  error = 1e-06,
  n.iter = 10000,
  boot = FALSE,
  B.boot = 200,
  joint = FALSE,
  plot.cdf = FALSE,
  plot.joint = FALSE,
  display = TRUE
)
}
\arguments{
\item{y}{vector of event times}

\item{l}{vector of left truncation times}

\item{r}{vector of right truncation times}

\item{error}{prespecified error for convergence (default = 1e-6)}

\item{n.iter}{maximum number of iterations}

\item{boot}{Logical. Default=FALSE. If TRUE, the simple bootstrap method is applied to estimate the standard error
and pointwise confidence intervals of the event time distribution}

\item{B.boot}{Numeric value for number of bootstrap resamples. Default is 200.}

\item{joint}{Logical. Default=FALSE. If TRUE, computes joint and marginal distributions of the truncation times}

\item{plot.cdf}{Logical. Default is FALSE. If TRUE, the estimated cumulative distribution and survival functions
of the event times are plotted. If boot=TRUE, confidence intervals are also plotted.}

\item{plot.joint}{Logical. Default is FALSE. If TRUE, the estimated marginal distribution functions of the truncation times,
and the joint distribution of the truncation times, are plotted. Note: Plot will only be displayed if both plot.joint=TRUE
and joint=TRUE.}

\item{display}{Logical. Default is TRUE. If FALSE, output will not be displayed upon execution of function.}
}
\value{
\item{time}{Unique event times of the event time vector y}
\item{n.event}{Number of events that occurred at each timepoint}
\item{F}{Estimated cumulative distribution function of Y at each distinct value of y}
\item{Survival}{Estimated survival function of Y at each distinct value of y (equal to 1-F)}
\item{sigma.F}{Bootstrapped standard error of F at each distinct value of y (displayed if boot=TRUE)}
\item{CI.lower.F}{Estimated lower limits of the Wald confidence intervals for F (displayed if boot=TRUE).}
\item{CI.upper.F}{Estimated upper limits of the Wald confidence intervals for F (displayed if boot=TRUE).}
\item{P.K}{Probability of the observed vector y falling within a random truncation interval [L,R]}
\item{Joint.LR}{Estimated joint distribution function of (l,r)}
\item{Marginal.L}{Estimated marginal cumulative distribution function of L at each observed l}
\item{Marginal.R}{Estimated marginal cumulative distribution function of R at each observed r}
\item{n.iterations}{Number of iterations needed for convergence}
\item{max.iter_reached}{0 indicates convergence, 1 indicates that number of iterations exceeded n.iter}
}
\description{
This function computes the NPMLE of the event time distribution and truncation time distribution, when the event times
are subject to double truncation.
}
\details{
Estimates the distribution function of the survival time in the presence
of left and right truncation. Also estimates the joint cumulative distribution function
and marginal cumulative distribution functions of the left and right truncation times.
The computation is performed using the algorithm introduced in Shen (2010).
This is an iterative algorithm that converges to the NPMLE after a number of iterations.
Note that the survival, left, and right truncation times must be the same length.
If either of these vectors have missing observations, the entire observation will be excluded.
}
\examples{
#AIDS data set:
out=cdfDT(AIDS$Induction.time,AIDS$L.time,AIDS$R.time,plot.cdf=TRUE)
out
}
\references{
Shen P-S (2010). Nonparametric analysis of doubly truncated data. Ann Inst Stat Math 62(5):835-853
}
