% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{move_legend_to_separate_plot}
\alias{move_legend_to_separate_plot}
\title{Create a ggplot with legend in a separate plot}
\usage{
move_legend_to_separate_plot(plot, legend_rel_height = 0.4)
}
\arguments{
\item{plot}{(\code{ggplot}) A ggplot object whose legend is to be separated.}

\item{legend_rel_height}{(\code{numeric(1)}) A numeric value indicating the relative height of the legend plot compared to the main plot. Default is 0.4.}
}
\value{
A ggplot object with the legend placed in a separate plot.
}
\description{
Using cowplot, this function extracts the legend from a ggplot object
and places it in a separate plot below the original plot without the legend.
This is useful for creating cleaner visualizations where the legend is displayed separately.
}
\keyword{internal}
