% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_db.R
\name{query_db}
\alias{query_db}
\title{Query Database}
\usage{
query_db(
  conn,
  arguments,
  target_vars = "default",
  target_table = "observation_table",
  argument_relation = "and"
)
}
\arguments{
\item{conn}{The connection object to an SQLite database.}

\item{arguments}{A list of filtering arguments for the query. The list must have only one filter argument per list-entry.}

\item{target_vars}{A character vector specifying the variables to be included in the query results.}

\item{target_table}{The target table in the database for querying.}

\item{argument_relation}{A character string specifying the relation between filtering arguments ("and" or "or" or a numerical vector with the same length as the number of arguments). Arguments with equal numbers in their index are joined using the OR operator, others using AND. To represent (A OR B) AND C AND D use the vector c(1, 1, 2, 3).}
}
\value{
A data frame containing the query results.
}
\description{
This function performs targeted queries on an SQLite database using specified filtering arguments and returns the query results.
It extracts information about which tables of the database are relevant for the query and then joins these relevant tables to the target table.
The function constructs an SQL query which incorporates both the joining and filtering target variables. This SQL statement is then applied to the database and the resulting dataframe is returned to the user.
}
\examples{
\dontrun{
conn <- connect_to_db("path/to/database.db")

arguments <- add_argument(list(), "publication_id", "greater", 0)

target_vars <- c("default", "n_participants")

target_table <- "study_table"

results <- query_db(conn, arguments, target_vars, target_table)
}
}
