% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{mca_pa}
\alias{mca_pa}
\title{Parallel Analysis for MCA Dimensionality Assessment}
\usage{
mca_pa(
  data,
  vars,
  B = 2000,
  q = 0.95,
  seed = 20260123,
  max_dims = 20,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame or path to .xlsx file}

\item{vars}{Character vector of binary variable names}

\item{B}{Integer, number of permutations (default: 2000)}

\item{q}{Numeric, reference quantile for retention (default: 0.95)}

\item{seed}{Integer, random seed for reproducibility}

\item{max_dims}{Integer, maximum dimensions to display in plot}

\item{verbose}{Logical, print progress messages}
}
\value{
S3 object of class \code{mca_pa} containing:
  \item{eig_obs}{Observed eigenvalues from the MCA of the original data}
  \item{eig_q}{Reference quantiles from permutation distribution}
  \item{eig_perm}{Matrix of permutation eigenvalues (B x dimensions)}
  \item{K_star}{Suggested number of dimensions to retain (where observed > reference)}
  \item{fit}{MCA fit object (class \code{mca_fit}) from original data}
  \item{q}{Quantile threshold used for comparison}
  \item{B}{Number of permutations performed}
}
\description{
Compares observed MCA eigenvalues against reference distributions from
permuted data to identify statistically meaningful dimensions.
}
\examples{
\donttest{
# Using included ANR2 dataset
data(ANR2)
pa <- mca_pa(ANR2, vars = names(ANR2), B = 100)
print(pa$K_star)
}
}
